#!/usr/bin/env php
<?php
/**
 * Piece Framework 用スケルトン作成スクリプト
 * @version  SVN: $Id$
 */

$flow_name = $validation_name = null;
switch ($argc) {
case 3:
    $validation_name = $argv[2];
case 2:
    $flow_name = $argv[1];
    break;
default:
    println("Usage: $argv[0] FlowName [ValidationName]");
    exit(0);
}

// スケルトンファイルのディレクトリ
$CONFIG['skel_dir'] = "/var/www/piece-gen/skel";

// スケルトンファイル
$CONFIG['entry_file']      = "/htdocs/flowname.php";
$CONFIG['action_file']     = "/webapp/actions/FlowNameAction.php";
$CONFIG['flow_file']       = "/webapp/config/flows/FlowName.yaml";
$CONFIG['validation_file'] = "/webapp/config/validations/ValidationName.yaml";
$CONFIG['template_file']   = "/webapp/templates/FlowName/*.html";

// 置換するキーワード
$CONFIG['keywords'] = array(
    "FLOW_NAME" => $flow_name,
    "AUTHOR"    => "Asial Corporation <info@asial.co.jp>"
);

if (!is_dir('htdocs') || !is_dir('webapp')) {
    println("target directory is not found!");
    exit(1);
}

$target_dir = getcwd();

$src = $CONFIG['skel_dir'] . $CONFIG['entry_file'];
$dst = $target_dir . str_replace('flowname', strtolower($flow_name), $CONFIG['entry_file']);
generate_file($src, $dst, $CONFIG['keywords']);

$src = $CONFIG['skel_dir'] . $CONFIG['action_file'];
$dst = $target_dir . str_replace('FlowName', $flow_name, $CONFIG['action_file']);
generate_file($src, $dst, $CONFIG['keywords']);

$src = $CONFIG['skel_dir'] . $CONFIG['flow_file'];
$dst = $target_dir . str_replace('FlowName', $flow_name, $CONFIG['flow_file']);
generate_file($src, $dst, $CONFIG['keywords']);

if ($validation_name) {
    $src = $CONFIG['skel_dir'] . $CONFIG['validation_file'];
    $dst = $target_dir . str_replace('ValidationName', $validation_name, $CONFIG['validation_file']);
    generate_file($src, $dst, $CONFIG['keywords']);
}

$src = $CONFIG['skel_dir'] . $CONFIG['template_file'];
$dst = dirname($target_dir . str_replace('FlowName', $flow_name, $CONFIG['template_file']));
generate_files($src, $dst, $CONFIG['keywords']);

$msg = "
piece-unity-config.yaml:
        - name: $flow_name
          file: ../webapp/config/flows/$flow_name.yaml
          isExclusive: false
";
println($msg);

exit(0);

/**
 * ファイルを生成する
 *
 * @param string $src_file 作成元のファイル名
 * @param string $dst_file 作成先のファイル名
 * @param array  $keywords 置換するキーワード
 */
function generate_file($src_file, $dst_file, $keywords)
{
    if (!file_exists($src_file)) {
			return;
		}

    $content = file_get_contents($src_file);
    foreach ($keywords as $key => $value) {
        $content = str_replace('%%' . $key . '%%', $value, $content);
    }

    $dst_dir = dirname($dst_file);
    if (!is_dir($dst_dir)) {
        mkdir($dst_dir, 0775, true);
        println("mkdir $dst_dir", 0);
    }

    if (!file_exists($dst_file)) {
        file_put_contents($dst_file, $content);
        println("$src_file -> $dst_file");
    }
}

/**
 * 複数のファイルを生成する
 *
 * @param string $src_file 作成元のファイル名
 * @param string $dst_dir  作成先のディレクトリ名
 * @param array  $keywords 置換するキーワード
 */
function generate_files($src_file, $dst_dir, $keywords)
{
    $src_files = glob($src_file);
    foreach ($src_files as $file) {
        $dist_file = $dst_dir . '/' . basename($file);
        generate_file($file, $dist_file, $keywords);
    }
}

/**
 * 文字列を出力する
 *
 * @param string  $string 出力する文字列
 * @param integer $level  出力レベル
 */
function println($string, $level = 3)
{
    switch ($level) {
    case 0:
        break;
    default:
        print("$string\n");
    }
}

?>
