<?php

require_once 'configure.php';
require_once 'Piece/ORM.php';

$mapper = Piece_ORM::getMapper('Framework');

$data = array(
  'Piece Framework' => 'http://piece-framework.com/',
  'symfony'         => 'http://www.symfony-project.org/',
  'CakePHP'         => 'http://www.cakephp.org/',
);

// INSERT
foreach ($data as $name => $uri) {
  $framework = $mapper->createObject();
  $framework->name = $name;
  $framework->uri = $uri;
  $mapper->insert($framework);
}
$frameworks = $mapper->findAll();
disp_timestamps($frameworks);

echo "\n";

// UPDATE
foreach ($frameworks as $framework) {
  $mapper->update($framework);
}
$frameworks = $mapper->findAll();
disp_timestamps($frameworks);

function disp_timestamps($frameworks) 
{
  foreach ($frameworks as $framework) {
    echo "[{$framework->name}]\n";
    echo "  created_at: {$framework->createdAt}\n";
    echo "  updated_at: {$framework->updatedAt}\n";
  }
}

?>
