window.addEventListener("load", function() {
    //PhoneGapロード完了になったときに onDeviceReady 関数を呼ぶようにする
    document.addEventListener("deviceready", onDeviceReady, false);
});
//共通変数
var LOGFILE_NAME = "logFile.txt";
var logFile;
var seekPos;
var logWriter;
//readyState = 1(WRITING)のため書き込めなかったメッセージ
var writeMiss = [];
//PhoneGapロード完了になったときに呼ばれる処理
function onDeviceReady() {
    //ログ
    console.log("start");
    //ファイルシステムを呼び出す
    window.requestFileSystem(LocalFileSystem.PERSISTENT, 0,
        onSuccessFileSystem, onFailFileSystem);
}
function onFailFileSystem(event) {
     alert(event.target.error.code);
}
//ファイルシステム呼び出し成功
function onSuccessFileSystem(fileSystem) {
    //rootディレクトリーからファイルエントリー取得
    var dirEntry = fileSystem.root;
    dirEntry.getFile(LOGFILE_NAME, 
        {create: true, exclusive: false}, 
        onSuccessGetFile, onFailGetFile);
}
function onFailGetFile(error) {
    alert("Failed to retrieve file: " + error.code);
}
//getFile成功
function onSuccessGetFile(parent) {
    //FileWriter用にファイルエントリーを保存
    logFile = parent;
    //ファイルオブジェクト作成
    parent.file(onSuccessFile, onFailFile);
}
function onFailFile(error) {
    alert("Failed to file method: " + error.code);
}
//file成功
function onSuccessFile(file) {
    var readText;
    var reader = new FileReader();
    reader.onloadend = function(evt) {
        console.log("read success");
        //読み込んだ結果
        readText = evt.target.result;
        //最初の日付を判断し、上書きか、追記かを決定
        var logDate = readText.substr(0,10);
        if (logDate < _getYyyymmdd(new Date())) {
            seekPos = 0;
        } else {
            seekPos = file.size;
        }
        logFile.createWriter(onSuccessWriter, onFailWriter);
    };
    reader.readAsText(file);
}
function onFailWriter(error) {
    console.log("onFailWriter:" + error.code);
}
//writer成功
function onSuccessWriter(writer) {
    logWriter = writer;
    writer.seek(seekPos);
    //アプリの初期化処理
    mainInit();    
}
//アプリの初期化処理
function mainInit() {
    //ボタン表示
    document.getElementById("writeButton").style.display = "";
    
    //日本語はうまくない。(1.4.1でもダメ)
    _logWrite("ログ記録開始しました。");
//    _logWrite("log start");
}

function writeLog() {
    _logWrite("タップされました。");
//  連続書き込みを行うと、logWriter.readyStateが 1 となり、
//  強引に書き込むと例外発生となる
    _logWrite("連続書き込みのテスト");
}

//終了時の処理
//書き込みできなかったメッセージを書き込む
function onUnload() {
    if (writeMiss.length == 0) {
        logWriter.write("---正常終了---\n");    
    } else {
        var lastMsg = "---busyで保留されたメッセージ---\n";
        for (var i = 0; i < writeMiss.length; i++) {
            lastMsg = lastMsg + writeMiss[i];
        }
        logWriter.write(lastMsg + "------\n");
    }
}



/**************************************************
 * [機能]   ログファイルに書き込みます。
 * [引数]   msg ログに書き込むメッセージ
 * [戻値]   なし
 **************************************************/
function _logWrite(msg) {
    /************************************************************
     * [重要]このコード作成時点でwriteメソッドにバグがあります。
     * 書き込む文字列がマルチバイトを含んでいると、
     * ポインターの移動が文字数(?)のため、次のwriteで
     * 前のデータの一部が上書きされます。
     * そのため、（バイト数－文字数）分の半角空白を追加します。
     * PhoneGapのバグがなおったらこのコードは修正の必要があります。
     *************************************************************/
    //（バイト数－文字数）を求める
    var plusBytes = _byteCount(msg) - msg.length;
    var plus = "";
    for (var i = 0; i < plusBytes; i++) {
        plus = plus + " ";
    }
    var logMsg = _getYyyymmddhhmmssfff(new Date()) + "|" + msg + "\n";
    var readyState = logWriter.readyState;
    console.log(readyState);
    if (readyState == 1) {
        //書き込み中は配列に蓄える
        writeMiss.push(logMsg);
    } else {
        //バグ対応のため余分な空白追加
        logWriter.write(logMsg + plus);
    }
}

/**************************************************
 * [機能]   日時を書式化します。
 * [引数]   date 日付
 * [戻値]    yyyy/MM/dd HH:mm:ss.fff
 **************************************************/
function _getYyyymmddhhmmssfff(date) {
    var res = date.getFullYear();
    res = res + "/" + _comPadZero(date.getMonth() + 1, 2);
    res = res + "/" + _comPadZero(date.getDate(), 2);
    res = res + " " + _comPadZero(date.getHours(), 2);
    res = res + ":" + _comPadZero(date.getMinutes(), 2);
    res = res + ":" + _comPadZero(date.getSeconds(), 2);
    res = res + "." + _comPadZero(date.getMilliseconds(), 3);
    return res;
}
/**************************************************
 * [機能]   日時を書式化します。
 * [引数]   date 日付
 * [戻値]    yyyy/MM/dd
 **************************************************/
function _getYyyymmdd(date) {
    var res = date.getFullYear();
    res = res + "/" + _comPadZero(date.getMonth() + 1, 2);
    res = res + "/" + _comPadZero(date.getDate(), 2);
    return res;
}
/**************************************************
 * [機能]   ゼロパディングを行います
 * [引数]   value   対象の文字列
 *          length  長さ
 * [戻値]   結果文字列
 **************************************************/
function _comPadZero(value, length){
    return new Array(length - ('' + value).length + 1).join('0') + value;
}
/**************************************************
 * [機能]   文字列のバイト数を返します。
 * [引数]   文字列
 * [戻値]   バイト数
 **************************************************/
function _byteCount(str) {
    //urlエンコード
    var ue = encodeURI(str);
    //%の数を調べる
    var per = ue.match(/%/g);
    if (per == null) {
        return str.length;
    } else {
        return ue.length - per.length * 2;
    }
}

